@extends('students-dashboard.app')

@section('title', 'My Mark Sheet')

@section('content')
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400..700&family=Open+Sans:ital,wght@0,300..800;1,300..800&family=PT+Sans:ital,wght@0,400;0,700;1,400;1,700&family=Poppins:ital,wght@0,200;0,300;1,200;1,300;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');

        body {
            font-family: "Roboto", sans-serif;
            font-style: normal;
        }
        a {
            text-decoration: none;
        }
        .container {
            max-width: 860px;
            padding: 20px 0;
            margin: auto;
        }
        .first-row {
            padding: 20px 10px;
            background-color: transparent;
            border: 3px double #ccc;
        }
        table, th, td {
            border: 1px solid black;
            border-collapse: collapse;
        }

        .first-table-wrapper {
            display: flex;
            gap: 20px;
            justify-content: center;
            margin-top: 15px;
        }

        .left-side {
            text-align: center;
        }

        .left-side h2 {
            font-size: 22px;
            width: 266px;
        }

        .left-side a {
            background-color: #000;
            padding: 8px 10px;
            color: #fff;
            display: inline-block;
            border-radius: 4px;
            cursor: pointer;
        }

        .result-table {
            border: 2px solid #565656;
            margin-top: 20px;
        }

        .second-and-third-wrapper {
            height: 560px;
        }

        .second-table-wrapper {
            margin-top: 25px;
        }

        .third-table-wrapper {
            display: flex;
            gap: 20px;
            margin-top: 25px;
        }

        .last-table-wrapper {
            margin-top: 25px;
        }

        .sig {
            font-family: "Dancing Script", cursive;
            font-weight: 600;
            text-align: center;
        }

        table tr td {
            padding-left: 5px;
        }

        .col-height {
            height: 34px;
        }

        .bg-gray {
            background-color: #e9e9e9;
        }

        /*//water-mark*/
        .container .first-row {
            position: relative;
        }

        .container .first-row .ms__icon {
            /* background-image: url({{ asset('/default/icon-marksheet1.png') }}); */
            position: absolute;
            background-repeat: no-repeat;
            background-position: center;
            background-size: contain;
            width: 349px;
            height: 349px;
            opacity: .15;
            left: 37%;
            top: 48%;
        }
    </style>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                @if (isset($students) && !$students->isEmpty())
                    <div class="card">
                        <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                            <h5>Mark Sheet (Total Result: {{count($students)}})</h5>
                            <div>
                                <button class="btn btn-sm btn-primary" onclick="printMarkDiv()">Print</button>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card mt-4">

                        <div class="card-body table_content">
                            @php
                                $grades_str = '';
                                foreach ($grades as $grade) {
                                    $grades_str .= "<tr>
                                                <td align='center'>$grade->mark_from-$grade->mark_to</td>
                                                <td align='center'>$grade->name</td>
                                                <td align='center'>$grade->remark</td>
                                            </tr>";
                                }

                                $head_marks_array = json_decode($assignedMarksHead->first(), true);

                                $head_id_array = array_keys($head_marks_array);
                                $subject_head_marks = $assignedMarksHead;
                                $highest_grand_total_obtain = 0;
                            @endphp

                            @foreach ($students as $key => $student)
                                @php
                                    $grand_total = 0;
                                    $grand_total_obtain = 0;
                                    $fail_count = 0;
                                    $exam = $exams[$exam_id] ?? '';
                                    $head_wise_grand_total = [];
                                    $section = $sections[$student->section_id] ?? '';
                                    $class = $studentClasses[$student->student_class_id] ?? '';
                                    $academicYear = $academicYears[$academic_year] ?? '';
                                    $examRecords = $student?->examRecords ?? '';
                                @endphp
                                @if ($examRecords->isNotEmpty())
                                    <section class="page-section">
                                        <div class="container">
                                            <div class="table-responsive">
                                                <div class="first-row">
                                                    <div class="ms__icon"></div>
                                                    <div class="first-table-wrapper">
                                                    <div class="left-side" style="width: 30%;">
                                                        <p>Jabalunnur Al-Jamiatul Islamia</p>
                                                        {{-- <a href="">Academic Transcript</a> --}}
                                                        <div class="first-table-wrapper">
                                                            <img src="{{ asset('uploads/images/logo-white.jpg') }}"
                                                                height="135" width="200" alt="">
                                                        </div>
                                                    </div>
                                                    <div class="middle-side" style="width: 30%;">
                                                        <div class="student-information">
                                                            <table border="1" width="100%" height="250px">
                                                                <tr>
                                                                    <th colspan="2" align="center">Student Information
                                                                    </th>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">ID</th>
                                                                    <td align="center">{{ $student->student_id_no }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Name</th>
                                                                    <td align="center" class="">
                                                                        {{ $student->first_name }} {{ $student->last_name }}
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Session</th>
                                                                    <td align="center">{{ $academicYear }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Class</th>
                                                                    <td align="center">{{ $class }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Section</th>
                                                                    <td align="center">{{ $section }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Roll</th>
                                                                    <td align="center">{{ $student->class_roll }}</td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    <div class="right-side" style="width: 40%;">
                                                        <div class="Grade-referance">
                                                            <table border="1" width="100%" height="250px">
                                                                <tr>
                                                                    <th colspan="3" align="center">Grade Referance</th>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Marks(%)</th>
                                                                    <th align="center">Grade</th>
                                                                    <th align="center">Comments</th>
                                                                </tr>
                                                                {!! $grades_str !!}
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="second-and-third-wrapper">
                                                    <div class="second-table-wrapper">
                                                        <table class="result-table" width="100%">

                                                            <tr>
                                                                <th rowspan="2">Subject</th>
                                                                <th rowspan="2" class="bg-gray">Full <br> Marks</th>
                                                                <th colspan="{{ count($head_id_array) + 3 }}"
                                                                    class="text-center col-height">{{ $exam }}</th>
                                                            </tr>

                                                            <tr align="center">
                                                                @if (isset($head_id_array))
                                                                    @foreach ($markHeads as $head)
                                                                        @if (in_array($head->id, $head_id_array))
                                                                            <th>{{ $head->short_name }}</th>
                                                                        @endif
                                                                    @endforeach
                                                                @endif
                                                                <th>Total Obt.</th>
                                                                <th>Grade</th>
                                                                <th>Heighest marks</th>
                                                            </tr>

                                                            @foreach ($examRecords as $recoards)
                                                                @php
                                                                    $full_marks = 0;
                                                                    $head_wise_total_obtain = [];
                                                                    $total_marks_obtain = 0;
                                                                    $head_records_str = '';

                                                                    $head_wise_marks_record = json_decode(
                                                                        $recoards->head_wise_marks,
                                                                    );

                                                                    $head_marks_data =
                                                                        $subject_head_marks[$recoards->subject->id];
                                                                    $head_marks_array = json_decode($head_marks_data);

                                                                @endphp
                                                                <tr align="center">
                                                                    <td align="left">
                                                                        {{ $recoards->subject->subject_name }}</td>

                                                                    @if (isset($head_wise_marks_record))
                                                                        @foreach ($markHeads as $head)
                                                                            @if (in_array($head->id, $head_id_array))
                                                                                @php
                                                                                    $full_marks +=
                                                                                        $head_marks_array->{$head?->id};
                                                                                    $head_records_str .=
                                                                                        '<td>' .
                                                                                        ($head_wise_marks_record?->{$head?->id} ??
                                                                                            '-') .
                                                                                        '</td>';
                                                                                    $total_marks_obtain +=
                                                                                        $head_wise_marks_record?->{$head?->id} ??
                                                                                        0;
                                                                                    $head_wise_grand_total[$head?->id] =
                                                                                        ($head_wise_grand_total[
                                                                                            $head?->id
                                                                                        ] ??
                                                                                            0) +
                                                                                        ($head_wise_marks_record?->{$head?->id} ??
                                                                                            0);
                                                                                @endphp
                                                                            @endif
                                                                        @endforeach

                                                                        <td class="bg-gray">{{ $full_marks }}</td>
                                                                        {!! $head_records_str !!}

                                                                        @php
                                                                            $grand_total_obtain += $total_marks_obtain;
                                                                            $grand_total += $full_marks;
                                                                        @endphp
                                                                    @endif

                                                                    <td>{{ $total_marks_obtain }}</td>
                                                                    @php
                                                                        $subject_grade_name = '';
                                                                        $grade_name_remarks = '';
                                                                        $total_percentage =
                                                                            $total_marks_obtain > 0 && $full_marks > 0
                                                                                ? round(
                                                                                    ($total_marks_obtain * 100) /
                                                                                        $full_marks,
                                                                                )
                                                                                : 0;
                                                                        foreach ($grades as $grade) {
                                                                            if (
                                                                                $grade->mark_from <=
                                                                                    $total_percentage &&
                                                                                $grade->mark_to >= $total_percentage
                                                                            ) {
                                                                                $subject_grade_name = $grade->name;
                                                                                if ($subject_grade_name == 'F') {
                                                                                    $fail_count++;
                                                                                }
                                                                            }
                                                                        }
                                                                    @endphp
                                                                    <td>{{ $subject_grade_name }}</td>
                                                                    <td>
                                                                        {{-- @dd($highest_marks_array) --}}
                                                                        @if (array_key_exists($recoards->subject->id, $highest_marks_array))
                                                                            {{ round($highest_marks_array[$recoards->subject->id]) }}
                                                                        @endif
                                                                    </td>
                                                                </tr>
                                                            @endforeach

                                                            @php
                                                                if ($grand_total_obtain > $highest_grand_total_obtain) {
                                                                    $highest_grand_total_obtain = $grand_total_obtain;
                                                                }
                                                            @endphp

                                                            <tr align="center">
                                                                <td align="left"> <b>Grand Total</b></td>
                                                                <td class="bg-gray"><b>{{ $grand_total }}</b></td>
                                                                @foreach ($markHeads as $head)
                                                                    @if (in_array($head->id, $head_id_array))
                                                                        <th>{{ $head_wise_grand_total[$head->id] }}</th>
                                                                    @endif
                                                                @endforeach
                                                                <td> <b>{{ $grand_total_obtain }}</b></td>
                                                                <td></td>
                                                                <td class="highest-grand-total"></td>
                                                            </tr>

                                                            @php
                                                                $grade_name = '';
                                                                $grade_name_remarks = '';
                                                                $grand_total_percentage =
                                                                    $grand_total_obtain > 0 && $grand_total > 0
                                                                        ? round(
                                                                            ($grand_total_obtain * 100) / $grand_total,
                                                                        )
                                                                        : 0;
                                                                foreach ($grades as $grade) {
                                                                    if (
                                                                        $grade->mark_from <= $grand_total_percentage &&
                                                                        $grade->mark_to >= $grand_total_percentage
                                                                    ) {
                                                                        $grade_name = $grade->name;
                                                                        $grade_name_remarks = $grade->remark;
                                                                    }
                                                                }

                                                            @endphp

                                                            <tr align="center">
                                                                <td class="col-height" align="left"> <b>Percentage</b>
                                                                </td>
                                                                <td colspan="{{ count($head_id_array) + 4 }}">
                                                                    <b>{{ round($grand_total_percentage, 2) }}%</b>
                                                                </td>
                                                            </tr>
                                                            <tr align="center">
                                                                <td class="col-height" align="left"><b>Grade</b></td>
                                                                <td colspan="{{ count($head_id_array) + 4 }}">
                                                                    @if ($fail_count > 0)
                                                                        <b>F</b>
                                                                    @else
                                                                        <b>{{ $grade_name }}</b>
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>

                                                    <div class="third-table-wrapper">
                                                        <div class="work-information" style="width: 40%;">
                                                            <table border="1" width="100%">

                                                                <tr>
                                                                    <td style="width: 50%">Working Days</td>
                                                                    <td style="width: 50%">80</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Present</td>
                                                                    <td>{{ '' }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Absent</td>
                                                                    <td>{{ '' }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Remarks</td>
                                                                    <td></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Result Published</td>
                                                                    <td>{{ $publish_date }}</td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                        <div class="conduct-info" style="width: 60%;">
                                                            <table border="1" width="100%">

                                                                <tr>
                                                                    <td style="width: 50%">Conduct</td>
                                                                    <td style="width: 50%"></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Moral Development</td>
                                                                    <td></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Discipline</td>
                                                                    <td></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Hand Writing</td>
                                                                    <td></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>General Remark</td>
                                                                    <td>{{ $grade_name_remarks }}</td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="last-table-wrapper">
                                                    <table border="1" width="100%">
                                                        <tr>
                                                            <th>Class Teacher's Signature</th>
                                                            <th>Principle's Signature</th>
                                                            <th>Guardian's Signature</th>
                                                        </tr>
                                                        <tr>
                                                            <td class="sig" style="height: 30px"></td>
                                                            <td class="sig"><img width="150px"
                                                                    src="{{ asset('signature/principal.jpg') }}" /></td>
                                                            <td class="sig"></td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="page-break"></div>
                                    </section>
                                @endif
                            @endforeach
                        </div>

                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        @media print {
            .btn-primary {
                display: none;
            }

            .card {
                border: none !important;
            }

            .container-fluid {
                padding: 0 !important;
            }
        }
    </style>
@endpush
